package com.ejie.ab04b.dao.temp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0465stempDaoImpl generated by UDA, 29-jun-2017 10:57:17.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class DocumentosAperturasTempDaoImpl implements
		DocumentosAperturasTempDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT_COLUMNAS = "SELECT t1.ID_TIPO_DOC_091 IDTIPODOC091,t1.DESCRIPCION_ES_091 DESCRIPCIONES091,"
			+ " t1.DESCRIPCION_EU_091 DESCRIPCIONEU091, t1.TIPO_DOKUSI_091 TIPODOKUSI091, t1.ASUNTO_DOKUSI_091 ASUNTODOKUSI091, "
			+ " t1.APORT_GEN_091 APORTGEN091, t2.ID_DOCUMENTO_098 IDDOCUMENTO098, t2.ID_APERTURA_098 IDAPERTURA098, "
			+ " t2.ID_TIPO_DOC_098 IDTIPODOC098, t2.RUTA_PIF_098 RUTAPIF098, t2.NOMBRE_DOC_098 NOMBREDOC098, "
			+ " t2.OID_DOKUSI_098 OIDDOKUSI098 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoAperturas> rwMap = new RowMapper<DocumentoAperturas>() {
		public DocumentoAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			DocumentoAperturas documento = new DocumentoAperturas(
					resultSet.getLong("IDDOCUMENTO098"),
					resultSet.getLong("IDAPERTURA098"),
					resultSet.getString("RUTAPIF098"),
					resultSet.getString("NOMBREDOC098"), new TipoDocumento(
							resultSet.getLong("IDTIPODOC098")));

			documento.setOidDokusi065(resultSet.getString("OIDDOKUSI098"));

			return documento;
		}
	};

	private RowMapper<DocumentoAperturas> rwMapTipo = new RowMapper<DocumentoAperturas>() {
		public DocumentoAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoAperturas documento = new DocumentoAperturas(
					resultSet.getLong("IDDOCUMENTO098"),
					resultSet.getLong("IDAPERTURA098"),
					resultSet.getString("RUTAPIF098"),
					resultSet.getString("NOMBREDOC098"), null);

			documento.setOidDokusi065(resultSet.getString("OIDDOKUSI098"));

			documento.setTipoDocumento(new TipoDocumento((resultSet
					.getLong("IDTIPODOC098") == 0 ? resultSet
					.getLong("IDTIPODOC091") : resultSet
					.getLong("IDTIPODOC098")), resultSet
					.getString("DESCRIPCIONES091"), resultSet
					.getString("DESCRIPCIONEU091"), resultSet
					.getString("TIPODOKUSI091"), resultSet
					.getString("ASUNTODOKUSI091"), resultSet
					.getString("APORTGEN091")));

			return documento;
		}
	};

	private RowMapper<DocumentoAperturas> rwMapPK = new RowMapper<DocumentoAperturas>() {
		public DocumentoAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocumentoAperturas(resultSet.getLong("IDDOCUMENTO098"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0465stemp table.
	 * 
	 * ab0465stemp Ab0465stemp Ab0465stemp
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @return the documento aperturas
	 */
	public DocumentoAperturas add(DocumentoAperturas ab0465stemp) {
		String query = "INSERT INTO AB0498S00 (ID_DOCUMENTO_098, ID_APERTURA_098, RUTA_PIF_098, NOMBRE_DOC_098, ID_TIPO_DOC_098) VALUES (?,?,?,?,?)";

		Long idDocumentoTemp = UtilDAO.getNextId(this.jdbcTemplate,
				Secuencias.DOC_APERTURAS_TEMP.getCodSecuencia());

		ab0465stemp.setIdDocumento065(idDocumentoTemp);

		this.jdbcTemplate.update(query, ab0465stemp.getIdDocumento065(),
				ab0465stemp.getIdapetemp065(), ab0465stemp.getRutaPif065(),
				ab0465stemp.getNombreDoc065(), ab0465stemp.getTipoDocumento()
						.getIdTipoDoc091());
		return ab0465stemp;
	}

	/**
	 * Updates a single row in the Ab0465stemp table.
	 * 
	 * ab0465stemp Ab0465stemp Ab0465stemp
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @return the documento aperturas
	 */
	public DocumentoAperturas update(DocumentoAperturas ab0465stemp) {
		String query = "UPDATE AB0498S00 SET ID_APERTURA_098=?, RUTA_PIF_098=?, NOMBRE_DOC_098=?, ID_TIPO_DOC_098=?, OID_DOKUSI_098=? WHERE ID_DOCUMENTO_098=?";
		this.jdbcTemplate.update(query, ab0465stemp.getIdapetemp065(),
				ab0465stemp.getRutaPif065(), ab0465stemp.getNombreDoc065(),
				ab0465stemp.getTipoDocumento().getIdTipoDoc091(),
				ab0465stemp.getOidDokusi065(), ab0465stemp.getIdDocumento065());
		return ab0465stemp;
	}

	/**
	 * Finds a single row in the Ab0465stemp table.
	 * 
	 * ab0465stemp Ab0465stemp Ab0465stemp
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @return the documento aperturas
	 */
	@Transactional(readOnly = true)
	public DocumentoAperturas find(DocumentoAperturas ab0465stemp) {
		String query = "SELECT t1.ID_DOCUMENTO_098 IDDOCUMENTO098, t1.ID_APERTURA_098 IDAPERTURA098, t1.RUTA_PIF_098 RUTAPIF098, t1.NOMBRE_DOC_098 NOMBREDOC098, t1.ID_TIPO_DOC_098 IDTIPODOC098, t1.OID_DOKUSI_098 OIDDOKUSI098 FROM AB0498S00 t1  WHERE t1.ID_DOCUMENTO_098 = ?  ";

		List<DocumentoAperturas> ab0465stempList = this.jdbcTemplate.query(
				query, this.rwMap, ab0465stemp.getIdDocumento065());
		return (DocumentoAperturas) DataAccessUtils
				.uniqueResult(ab0465stempList);
	}

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 * documento SolicDocAperturas
	 * 
	 * List<SolicDocAperturas>.
	 * 
	 * @param documento
	 *            the documento
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> buscarDocumentosAperturasTempTipo(
			DocumentoAperturas documento) {
		StringBuilder query = new StringBuilder(
				DocumentosAperturasTempDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(" FROM AB0491S00 t1 LEFT JOIN AB0498S00 t2 ON  t2.ID_TIPO_DOC_098  = t1.ID_TIPO_DOC_091 ");
		query.append(" AND t2.ID_APERTURA_098 = ?  WHERE t1.APORT_GEN_091    = ? ");
		query.append(" AND t1.ASUNTO_DOKUSI_091 != '"
				+ Constantes.TIPO_DOC_INFORME_INSPECCION + "'");
		// + "' AND t1.ID_TIPO_DOC_091<>'6' ");
		query.append(" order by t1.ORDER_091 ");

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMapTipo, documento.getIdapetemp065(),
				documento.getTipoDocumento().getAportGen091());
	}

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 * documento SolicDocAperturas
	 * 
	 * List<SolicDocAperturas>.
	 * 
	 * @param documento
	 *            the documento
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> buscarDocumentosAperturasInspeccion(
			DocumentoAperturas documento) {
		StringBuilder query = new StringBuilder(
				DocumentosAperturasTempDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(" FROM AB0491S00 t1 LEFT JOIN AB0498S00 t2 ON  t2.ID_TIPO_DOC_098  = t1.ID_TIPO_DOC_091 ");
		query.append(" AND t2.ID_APERTURA_098 = ?  WHERE t1.APORT_GEN_091    = ? ");
		query.append(" AND t1.ASUNTO_DOKUSI_091 = '"
				+ Constantes.TIPO_DOC_INFORME_INSPECCION + "' ");

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMapTipo, documento.getIdapetemp065(),
				documento.getTipoDocumento().getAportGen091());
	}

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 * documento SolicDocAperturas
	 * 
	 * List<SolicDocAperturas>.
	 * 
	 * @param documento
	 *            the documento
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> buscarDocumentosAperturasTempIdApe(
			DocumentoAperturas documento) {
		StringBuilder query = new StringBuilder(
				DocumentosAperturasTempDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(" FROM AB0491S00 t1 LEFT JOIN AB0498S00 t2 ON  t2.ID_TIPO_DOC_098  = t1.ID_TIPO_DOC_091 ");
		query.append(" WHERE t2.ID_APERTURA_098 = ?  ");
		// query.append(" order by idtipodoc091 ");

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMapTipo, documento.getIdapetemp065());
	}

	/**
	 * Finds a list of rows in the SolicDocumentos table.
	 * 
	 * solicdocumentos SolicDocumentos jqGridRequestDto JQGridRequestDto List
	 * <SolicDocumentos>
	 * 
	 * @param solicdocumentos
	 *            the solicdocumentos
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> buscarPorIdApeYMetadatoNombre(
			DocumentoAperturas solicdocumentos,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentosAperturasTempDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(" FROM AB0491S00 t1 LEFT JOIN AB0498S00 t2 ON  t2.ID_TIPO_DOC_098  = t1.ID_TIPO_DOC_091 ");
		query.append(" WHERE t2.ID_APERTURA_098  = ? AND UPPER(SUBSTR(t2.NOMBRE_DOC_098, 1, INSTR(t2.NOMBRE_DOC_098, '.', -1) - 1)) = ? ");
		// El metadato object_name nos devuelve el nombre del fichero en
		// minúsculas y sin extensión
		// Buscamos ese nombre en mayúsculas descartando lo que haya en BD a
		// partir del último punto

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(query
				.toString(), this.rwMap, solicdocumentos.getIdapetemp065(),
				solicdocumentos.getNombreDoc065().toUpperCase());
	}

	/**
	 * Removes a single row in the Ab0465stemp table.
	 * 
	 * ab0465stemp Ab0465stemp
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 */
	public void remove(DocumentoAperturas ab0465stemp) {
		String query = "DELETE FROM AB0498S00 WHERE ID_DOCUMENTO_098=?";
		this.jdbcTemplate.update(query, ab0465stemp.getIdDocumento065());
	}

	/**
	 * Removes a single row in the Ab0465stemp table.
	 * 
	 * ab0465stemp Ab0465stemp
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 */
	public void removeByIdApertura(DocumentoAperturas ab0465stemp) {
		String query = "DELETE FROM AB0498S00 WHERE ID_APERTURA_098=?";
		this.jdbcTemplate.update(query, ab0465stemp.getIdapetemp065());
	}

	/**
	 * Finds a list of rows in the Ab0465stemp table.
	 * 
	 * ab0465stemp Ab0465stemp jqGridRequestDto JQGridRequestDto List
	 * <Ab0465stemp>
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> findAll(DocumentoAperturas ab0465stemp,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DOCUMENTO_098 IDDOCUMENTO098,t1.ID_APERTURA_098 IDAPERTURA098,t1.RUTA_PIF_098 RUTAPIF098,t1.NOMBRE_DOC_098 NOMBREDOC098,t1.ID_TIPO_DOC_098 IDTIPODOC098 ");
		query.append("FROM AB0498S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0465stemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0465stemp table using like.
	 * 
	 * ab0465stemp Ab0465stemp jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab0465stemp>
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> findAllLike(DocumentoAperturas ab0465stemp,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DOCUMENTO_098 IDDOCUMENTO098,t1.ID_APERTURA_098 IDAPERTURA098,t1.RUTA_PIF_098 RUTAPIF098,t1.NOMBRE_DOC_098 NOMBREDOC098,t1.ID_TIPO_DOC_098 IDTIPODOC098 ");
		query.append("FROM AB0498S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0465stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0465stemp table.
	 * 
	 * ab0465stemp Ab0465stemp Long
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentoAperturas ab0465stemp) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0498S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0465stemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0465stemp table using like.
	 * 
	 * ab0465stemp Ab0465stemp startsWith Boolean Long
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocumentoAperturas ab0465stemp,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0498S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0465stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0465stemp selected for rup_table
	 * 
	 * ab0465stemp Ab0465stemp jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<TableRowDto<Ab0465stemp>>.
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<DocumentoAperturas>> reorderSelection(
			DocumentoAperturas ab0465stemp, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DOCUMENTO_098 IDDOCUMENTO098,t1.ID_APERTURA_098 IDAPERTURA098,t1.RUTA_PIF_098 RUTAPIF098,t1.NOMBRE_DOC_098 NOMBREDOC098,t1.ID_TIPO_DOC_098 IDTIPODOC098 ");
		// FROM
		query.append("FROM AB0498S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0465stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DocumentoAperturas.class,
				filterParamList, "ID_DOCUMENTO_098");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoAperturas>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * filterParams Ab0465stemp searchParams Ab0465stemp jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0465stemp>>.
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<DocumentoAperturas>> search(
			DocumentoAperturas filterParams, DocumentoAperturas searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DOCUMENTO_098 IDDOCUMENTO098,t1.ID_APERTURA_098 IDAPERTURA098,t1.RUTA_PIF_098 RUTAPIF098,t1.NOMBRE_DOC_098 NOMBREDOC098,t1.ID_TIPO_DOC_098 IDTIPODOC098 ");
		// FROM
		query.append("FROM AB0498S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DocumentoAperturas.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ID_DOCUMENTO_098");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoAperturas>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0465stemp entity
	 * 
	 * ab0465stemp Ab0465stemp Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoAperturas ab0465stemp) {

		StringBuilder where = new StringBuilder(
				DocumentosAperturasTempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0465stemp != null && ab0465stemp.getIdDocumento065() != null) {
			where.append(" AND t1.ID_DOCUMENTO_098 = ?");
			params.add(ab0465stemp.getIdDocumento065());
		}
		if (ab0465stemp != null && ab0465stemp.getIdapetemp065() != null) {
			where.append(" AND t1.ID_APERTURA_098 = ?");
			params.add(ab0465stemp.getIdapetemp065());
		}
		if (ab0465stemp != null && ab0465stemp.getRutaPif065() != null) {
			where.append(" AND t1.RUTA_PIF_098 = ?");
			params.add(ab0465stemp.getRutaPif065());
		}
		if (ab0465stemp != null && ab0465stemp.getNombreDoc065() != null) {
			where.append(" AND t1.NOMBRE_DOC_098 = ?");
			params.add(ab0465stemp.getNombreDoc065());
		}
		if (ab0465stemp != null && ab0465stemp.getTipoDocumento() != null
				&& ab0465stemp.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_098 = ?");
			params.add(ab0465stemp.getTipoDocumento().getIdTipoDoc091());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0465stemp entity
	 * 
	 * ab0465stemp Ab0465stemp Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0465stemp
	 *            the ab 0465 stemp
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DocumentoAperturas ab0465stemp,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocumentosAperturasTempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0465stemp != null && ab0465stemp.getIdDocumento065() != null) {
			where.append(" AND t1.ID_DOCUMENTO_098 = ?");
			params.add(ab0465stemp.getIdDocumento065());
		}
		if (ab0465stemp != null && ab0465stemp.getIdapetemp065() != null) {
			where.append(" AND t1.ID_APERTURA_098 = ?");
			params.add(ab0465stemp.getIdapetemp065());
		}
		if (ab0465stemp != null && ab0465stemp.getRutaPif065() != null) {
			where.append(" AND UPPER(t1.RUTA_PIF_098) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0465stemp.getRutaPif065().toUpperCase() + "%");
			} else {
				params.add("%" + ab0465stemp.getRutaPif065().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RUTA_PIF_098 IS NOT NULL");
		}
		if (ab0465stemp != null && ab0465stemp.getNombreDoc065() != null) {
			where.append(" AND UPPER(t1.NOMBRE_DOC_098) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0465stemp.getNombreDoc065().toUpperCase() + "%");
			} else {
				params.add("%" + ab0465stemp.getNombreDoc065().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_DOC_098 IS NOT NULL");
		}
		if (ab0465stemp != null && ab0465stemp.getTipoDocumento() != null
				&& ab0465stemp.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_098 = ?");
			params.add(ab0465stemp.getTipoDocumento().getIdTipoDoc091());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
